 IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_PDV_VD_IT]'))
	DROP VIEW [DBO].[V_PDV_VD_IT]
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230511
'Job.................:  
'Nome................: [V_PDV_VD_IT]
'Objetivo............: 
'Tabelas.............: [PDV_VD_IT]
'Dt Criao..........: --
'Dt Ult Alteraco....: 11/05/2023
'Criado por..........: --
'Alterado por........: Juan Andres Fernandez Mello
'versionado por......: Marcos Barros
'=======================================================================================
-- SELECT * FROM V_PDV_VD_IT
*/
CREATE VIEW [dbo].[V_PDV_VD_IT]  
	AS 
	SELECT       
		I.CD_EMP,   
		I.CD_FILIAL,   
		V.CD_VD,   
		I.CD_VEND,   
		V.DT_CONSD,   
		V.CD_CX,   
		I.DT_VD,   
		I.CD_PROD,   
		I.QT_IT,   
		V.NR_ECF,         
		CASE WHEN (I.TOT_IT - I.VLR_DESC_TOT_RAT) > 0 THEN 
			I.TOT_IT - I.VLR_DESC_TOT_RAT
		ELSE
			0
		END AS TOT_IT,   
		ROUND(COALESCE(I.VLR_DESC, I.QT_IT * I.VLR_IT * I.TX_DESC / 100), 2)  AS VLR_DESC_IT,   
		ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2) - ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_IT_LIQ,   
		ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_VERBA,   
		(((I.QT_IT * I.VLR_IT * I.TX_DESC ) + I.VLR_DESC_TOT_RAT)/  I.QT_IT)/(I.QT_IT * I.VLR_IT)   AS DESC_TOTAL_IT,
		I.QT_IT * I.VLR_IT AS TOT_IT_BRUTO,   
		I.VLR_DESC_TOT_RAT,   
		I.VLR_IT,   
		I.TX_DESC,   
		I.CD_TRIB_FC,   
		CASE WHEN I.TX_RED_IT > 0 THEN
			I.TX_ICMS_IT * I.TX_RED_IT / 100
		ELSE
			I.TX_ICMS_IT
		END AS TX_ICMS_IT,  
		I.TX_ICMS_IT AS TX_ICMS_IT_CHEIO,
		I.TX_RED_IT, 
		V.VLR_DESC,  
		V.TIPO,   
		CASE WHEN I.TOT_IT > 0 THEN  
				CONVERT(FLOAT, I.VLR_DESC_TOT_RAT / I.TOT_IT)    
		ELSE 0 END AS PERC_DESC,  
		V.VLR_DINH,   
		V.VLR_CHQS,   
		V.VLR_CARTAO,   
		V.VLR_TICKETS,   
		V.VLR_DUP,   
		(V.VLR_CONV  + ISNULL( VLR_CONV_PBM, 0)) AS VLR_CONV,  
		V.VLR_TROCO_CHQ,   
		V.VLR_LIQ_VD,   
		I.CD_IT,   
		V.HR_VD,   
		V.CD_USU,   
		V.CD_CLI,   
		CASE WHEN I.QT_IT > 0 THEN   
				(((I.TOT_IT - I.VLR_DESC_TOT_RAT) / I.QT_IT) * 
				CASE WHEN I.TX_RED_IT > 0 THEN
					((I.TX_ICMS_IT * I.TX_RED_IT) / 100.0000)
				ELSE
					I.TX_ICMS_IT
				END) / 100.0000   
		ELSE 
			0 
		END AS VLR_IMPOSTOS,  
		I.VLR_CUSTO AS VLR_CUSTO_UNI_LIQ,         
		I.VLR_CUSTO AS VLR_CUSTO_BRUTO,   
		ISNULL(CD_TP_DESCONTO,0) AS TIPO_DESCONTO,
		ISNULL(DS_TP_DESCONTO,'') AS DS_TIPO_DESCONTO,  
		ISNULL(V.NR_ORC,0) AS NR_ORC,   
		V.VS_PDV,   
		ISNULL(V.ORIG_ORC,0) AS ORIG_ORC,   
		ISNULL(V.NR_CARTAO_MARKA, 0) AS NR_CARTAO_MARKA,   
		I.PIS_COFINS,   
		ISNULL(I.VLR_PMC, 0) AS VLR_PMC,   
		ISNULL(I.VLR_PMC, 0) * I.QT_IT AS VLR_PMC_TOTAL,   
		ISNULL(I.VLR_OFERTA, 0) AS VLR_OFERTA,   
		ISNULL(I.VLR_DESC_CAD, 0) AS VLR_DESC_CAD,   
		ISNULL(I.DESC_FIXADO_CAD, 0) AS DESC_FIXADO_CAD,   
		ISNULL(I.PERC_DESC_FIDEL, 0)  AS PERC_DESC_FIDEL,   
		ISNULL(I.PERC_DESC_FIDEL_MAX, 0) AS PERC_DESC_FIDEL_MAX,   
		CASE WHEN ISNULL(I.VLR_PMC,0) > I.VLR_IT THEN  
				(I.VLR_PMC - I.VLR_IT) * I.QT_IT   
		ELSE  
				0  
		END  AS VLR_DESC_OFERTA,   
		CASE WHEN ISNULL(I.TX_DESC,0)=0 THEN   
						CASE WHEN I.VLR_PMC > I.VLR_IT THEN  
								(I.VLR_PMC - I.VLR_IT) * I.QT_IT          
						ELSE  
								0  
						END  
		ELSE 	
			ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2)   
		END AS VLR_DESC_REAL,   
		ISNULL(IR.CD_MEDICO_REC, 0) AS CD_MEDICO_REC,   
		I.PERC_COMI,   
		ISNULL(I.VLR_CUSTO,0) AS VLR_CUSTO,   
		ISNULL(I.VLR_CUSTO_MEDIO,0) AS VLR_CUSTO_MEDIO,   
		I.PERC_COMI_CTR,   
		I.VD_OPERADOR,   
		V.CD_USU_OPE,   
		I.PERC_COMIS,   
		V.NR_PED_TELEVD,  
		(I.QT_IT * I.VLR_COMISSAO_FABRIC) AS VLR_COMISSAO_FABRIC,  
		CASE WHEN V.NR_PED_TELEVD >0 THEN 'TELEVENDAS'
		ELSE   
			CASE WHEN V.NR_ORC = 0 THEN   
					'DIRETO P.D.V'  
				ELSE  
					CASE WHEN ISNULL(V.ORIG_ORC,0) =0 THEN   
							'ORCAMENTO'  
						WHEN V.ORIG_ORC =1 THEN   
							'TELEVENDAS'  
						WHEN V.ORIG_ORC =2 THEN   
							'PBM'  
						WHEN V.ORIG_ORC =3 THEN   
							'DRIVE THRU'  
						WHEN V.ORIG_ORC =4 THEN   
							'NDF'  
						WHEN V.ORIG_ORC =5 THEN   
							'NDF'  
					END  
				END 		
		END AS ORIG_VENDA,    
				(CASE WHEN V.VLR_LIQ_VD > 0 THEN  
						CASE WHEN V.VLR_LIQ_VD = V.VLR_DINH THEN  
								CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
							ELSE  
								CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_DINH AS NUMERIC(18,4))) AS NUMERIC(18,4))   
							END  
				ELSE  
						0  
				END) AS VLR_DINH_IT,     
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
						WHEN V.VLR_LIQ_VD = V.VLR_CHQS THEN  
						CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
					ELSE  
						CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CHQS AS NUMERIC(18,2))) AS NUMERIC(18,2))   
					END) AS VLR_CHQS_IT,  
		ISNULL((CASE WHEN V.VL_CHQS_A_VISTA > 0 THEN  
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN  
		CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
		CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VL_CHQS_A_VISTA AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END)  
		END),0) AS VLR_CHQS_IT_VISTA,
		ISNULL((CASE WHEN V.VLR_LIQ_VD =0 THEN 0
					WHEN V.VL_CHQS_A_PRZ > 0 THEN  
		(CASE WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN  
		CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
		CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VL_CHQS_A_PRZ AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END)  
		END),0) AS VLR_CHQS_IT_PRAZO,                   
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_CARTAO THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CARTAO AS NUMERIC(18,2))) AS NUMERIC(18,3))   
		END) AS VLR_CARTAO_IT,   
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_TICKETS THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_TICKETS AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_TICKETS_IT,          
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_DUP THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_DUP AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_DUP_IT,                      
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_CONV THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CONV AS NUMERIC(18,4))) AS NUMERIC(18,4))   
		END) AS VLR_CONV_IT,  
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_TROCO_CHQ = 0  THEN   0  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_TROCO_CHQ AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_TROCO_CHQ_IT,  
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0	
			WHEN V.VLR_LIQ_VD = ISNULL(V.VLR_NCC,0) THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(ISNULL(V.VLR_NCC,0) AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_NCC_IT,                                       
		V.VD_TROCA_FIDEL,  
		V.DT_ULT_ALT,  
		V.VLR_TOT_PROD,  
		I.DT_VD DT_VD_IT,  
		ISNULL(I.CD_GRP_COMIS,0) AS  CD_GRP_COMIS,  
		I.LISTA_PROD,  
		I.PERC_DESC_VERBA,  
		I.CST_PIS,  
		I.CST_COFINS,  
		I.VLR_BASE_PIS ,  
		I.VLR_BASE_COFINS,  
		I.PERC_ALIQ_PIS,  
		I.PERC_ALIQ_COFINS,  
		I.VLR_PIS,  
		I.VLR_COFINS,  
		ISNULL(I.VLR_CUSTO_GER,0) AS VLR_CUSTO_GER,
		ISNULL(TIPO_TRIBUTACAO_PIS_COFINS,0)TIPO_TRIBUTACAO_PIS_COFINS,
		ISNULL(TIPO_IMPOSTO,0) AS TIPO_IMPOSTO,
		V.QT_PARC_CONV,
		ISNULL(V.CD_CONV,0) AS CD_CONV,
		ISNULL(V.FLAG_NFCE,0) AS FLAG_NFCE,
		ISNULL(I.DEPENDENTE,0) AS DEPENDENTE,
		I.TP_PROD,
		I.PERC_DESC_DIFF,
		ISNULL(I.PERC_DESC_MIN,0) AS PERC_DESC_MIM,
		I.PERC_DESC_MAX,
		I.DS_PERC_COMIS,
		I.DS_VLR_COMIS,
		V.CGC_CPF,
		1 TP_VD,
		ROUND((((I.TOT_IT - I.VLR_DESC_TOT_RAT) * I.PERC_COMIS) / 100),2) AS VL_COMIS,
		COALESCE(I.PERC_FECOP, 0) AS PERC_FECOP,
		V.CD_USU_CANCEL,
		V.NM_COMPRADOR,
		V.TP_VD_API,
		V.NR_CARTAO_API,
		I.PERC_RED_BASE_CALC_EFET,
	    I.PERC_ICMS_EFET,
	    I.PERC_ICMS_RET,
		I.PERC_ST,
		I.VLR_BASE_CALC_EFET, 
		I.VLR_ICMS_EFET,
		I.VLR_BASE_CALC_RET,
		I.VLR_ICMS_RET,
        COALESCE(I.VLR_FECOP, 0) AS VLR_FECOP,
        V.NR_ECF_UUID AS UUID,
		COALESCE(I.ALIQ_EFET_ICMS, 0) AS ALIQ_EFET_ICMS_IT,
		COALESCE(I.PERC_EFET_RED_BASE_CALC, 0) AS PERC_EFET_RED_BASE_CALC_IT,
		COALESCE(I.VLR_BASE_CALC_EFET, 0) AS VLR_BASE_CALC_EFET_IT,
		COALESCE(I.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_IT,
		COALESCE(V.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_CAB,
		COALESCE(V.VLR_BASE_CALC_EFET, 0) AS VLR_BASE_CALC_EFET_CAB,
		COALESCE(I.LIBERA_VD_CONV, 1) AS LIBERA_VD_CONV
	FROM 
		PDV_VD AS V   
		INNER    JOIN DBO.PDV_VD_IT AS I ON   
			V.CD_EMP        = I.CD_EMP AND   
			V.CD_FILIAL = I.CD_FILIAL AND   
			V.CD_VD         = I.CD_VD         
		AND V.DT_VD = I.DT_VD   
		LEFT OUTER JOIN DBO.PDV_VD_IT_REC AS IR ON   
			I.CD_EMP        = IR.CD_EMP AND   
			I.CD_FILIAL = IR.CD_FILIAL AND   
			I.CD_VD         = IR.CD_VD AND   
			I.CD_IT         = IR.CD_IT  
		LEFT OUTER JOIN GLB_TP_DESCONTO ON
			I.TIPO_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO 		
	WHERE       
		V.CD_EMP = 1   
		AND V.ST_VD = 0  
		AND I.ST_IT = 1
	UNION ALL
	SELECT       
		I.CD_EMP,   
		I.CD_FILIAL,   
		V.CD_VD,   
		I.CD_VEND,   
		V.DT_CONSD,   
		V.CD_CX,   
		I.DT_VD,   
		I.CD_PROD,   
		I.QT_IT,   
		V.NR_ECF,         
		CASE WHEN (I.TOT_IT - I.VLR_DESC_TOT_RAT) > 0 THEN 
			I.TOT_IT - I.VLR_DESC_TOT_RAT
		ELSE
			0
		END AS TOT_IT,   
		ROUND(COALESCE(I.VLR_DESC, I.QT_IT * I.VLR_IT * I.TX_DESC / 100), 2)  AS VLR_DESC_IT,   
		ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2) - ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_IT_LIQ,   
		ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_VERBA,   
		(((I.QT_IT * I.VLR_IT * I.TX_DESC ) + I.VLR_DESC_TOT_RAT)/  I.QT_IT)/(I.QT_IT * I.VLR_IT)   AS DESC_TOTAL_IT,
		I.QT_IT * I.VLR_IT AS TOT_IT_BRUTO,   
		I.VLR_DESC_TOT_RAT,   
		I.VLR_IT,   
		I.TX_DESC,   
		I.CD_TRIB_FC,   
		CASE WHEN I.TX_RED_IT > 0 THEN
			I.TX_ICMS_IT * I.TX_RED_IT / 100
		ELSE
			I.TX_ICMS_IT
		END AS TX_ICMS_IT,  
		I.TX_ICMS_IT AS TX_ICMS_IT_CHEIO,
		I.TX_RED_IT, 
		V.VLR_DESC,  
		V.TIPO,   
		CASE WHEN I.TOT_IT > 0 THEN  
				CONVERT(FLOAT, I.VLR_DESC_TOT_RAT / I.TOT_IT)    
		ELSE 0 END AS PERC_DESC,  
		V.VLR_DINH,   
		V.VLR_CHQS,   
		V.VLR_CARTAO,   
		V.VLR_TICKETS,   
		V.VLR_DUP,   
		(V.VLR_CONV  + ISNULL( VLR_CONV_PBM, 0)) AS VLR_CONV,  
		V.VLR_TROCO_CHQ,   
		V.VLR_LIQ_VD,   
		I.CD_IT,   
		V.HR_VD,   
		V.CD_USU,   
		V.CD_CLI,   
		CASE WHEN I.QT_IT > 0 THEN   
				(((I.TOT_IT - I.VLR_DESC_TOT_RAT) / I.QT_IT) * 
				CASE WHEN I.TX_RED_IT > 0 THEN
					((I.TX_ICMS_IT * I.TX_RED_IT) / 100.0000)
				ELSE
					I.TX_ICMS_IT
				END) / 100.0000   
		ELSE 
			0 
		END AS VLR_IMPOSTOS,  
		I.VLR_CUSTO AS VLR_CUSTO_UNI_LIQ,         
		I.VLR_CUSTO AS VLR_CUSTO_BRUTO,   
		ISNULL(CD_TP_DESCONTO,0) AS TIPO_DESCONTO,
		ISNULL(DS_TP_DESCONTO,'') AS DS_TIPO_DESCONTO,  
		ISNULL(V.NR_ORC,0) AS NR_ORC,   
		V.VS_PDV,   
		ISNULL(V.ORIG_ORC,0) AS ORIG_ORC,   
		ISNULL(V.NR_CARTAO_MARKA, 0) AS NR_CARTAO_MARKA,   
		I.PIS_COFINS,   
		ISNULL(I.VLR_PMC, 0) AS VLR_PMC,   
		ISNULL(I.VLR_PMC, 0) * I.QT_IT AS VLR_PMC_TOTAL,   
		ISNULL(I.VLR_OFERTA, 0) AS VLR_OFERTA,   
		ISNULL(I.VLR_DESC_CAD, 0) AS VLR_DESC_CAD,   
		ISNULL(I.DESC_FIXADO_CAD, 0) AS DESC_FIXADO_CAD,   
		ISNULL(I.PERC_DESC_FIDEL, 0)  AS PERC_DESC_FIDEL,   
		ISNULL(I.PERC_DESC_FIDEL_MAX, 0) AS PERC_DESC_FIDEL_MAX,   
		CASE WHEN ISNULL(I.VLR_PMC,0) > I.VLR_IT THEN  
				(I.VLR_PMC - I.VLR_IT) * I.QT_IT   
		ELSE  
				0  
		END  AS VLR_DESC_OFERTA,   
		CASE WHEN ISNULL(I.TX_DESC,0)=0 THEN   
						CASE WHEN I.VLR_PMC > I.VLR_IT THEN  
								(I.VLR_PMC - I.VLR_IT) * I.QT_IT          
						ELSE  
								0  
						END  
		ELSE 	
			ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2)   
		END AS VLR_DESC_REAL,   
		ISNULL(IR.CD_MEDICO_REC, 0) AS CD_MEDICO_REC,   
		I.PERC_COMI,   
		ISNULL(I.VLR_CUSTO,0) AS VLR_CUSTO,   
		ISNULL(I.VLR_CUSTO_MEDIO,0) AS VLR_CUSTO_MEDIO,   
		I.PERC_COMI_CTR,   
		I.VD_OPERADOR,   
		V.CD_USU_OPE,   
		I.PERC_COMIS,   
		V.NR_PED_TELEVD,  
		(I.QT_IT * I.VLR_COMISSAO_FABRIC) AS VLR_COMISSAO_FABRIC,  
		CASE WHEN V.NR_PED_TELEVD >0 THEN 'TELEVENDAS'
		ELSE   
			CASE WHEN V.NR_ORC = 0 THEN   
					'DIRETO P.D.V'  
				ELSE  
					CASE WHEN ISNULL(V.ORIG_ORC,0) =0 THEN   
							'ORCAMENTO'  
						WHEN V.ORIG_ORC =1 THEN   
							'TELEVENDAS'  
						WHEN V.ORIG_ORC =2 THEN   
							'PBM'  
						WHEN V.ORIG_ORC =3 THEN   
							'DRIVE THRU'  
						WHEN V.ORIG_ORC =4 THEN   
							'NDF'  
						WHEN V.ORIG_ORC =5 THEN   
							'NDF'  
					END  
				END 		
		END AS ORIG_VENDA,    
				(CASE WHEN V.VLR_LIQ_VD > 0 THEN  
						CASE WHEN V.VLR_LIQ_VD = V.VLR_DINH THEN  
								CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
							ELSE  
								CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_DINH AS NUMERIC(18,4))) AS NUMERIC(18,4))   
							END  
				ELSE  
						0  
				END) AS VLR_DINH_IT,     
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
						WHEN V.VLR_LIQ_VD = V.VLR_CHQS THEN  
						CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
					ELSE  
						CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CHQS AS NUMERIC(18,2))) AS NUMERIC(18,2))   
					END) AS VLR_CHQS_IT,  
		ISNULL((CASE WHEN V.VL_CHQS_A_VISTA > 0 THEN  
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN  
		CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
		CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VL_CHQS_A_VISTA AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END)  
		END),0) AS VLR_CHQS_IT_VISTA,
		ISNULL((CASE WHEN V.VLR_LIQ_VD =0 THEN 0
					WHEN V.VL_CHQS_A_PRZ > 0 THEN  
		(CASE WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN  
		CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
		CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VL_CHQS_A_PRZ AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END)  
		END),0) AS VLR_CHQS_IT_PRAZO,                   
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_CARTAO THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CARTAO AS NUMERIC(18,2))) AS NUMERIC(18,3))   
		END) AS VLR_CARTAO_IT,   
		(CASE WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_TICKETS THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_TICKETS AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_TICKETS_IT,          
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_DUP THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_DUP AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_DUP_IT,                      
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_LIQ_VD = V.VLR_CONV THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_CONV AS NUMERIC(18,4))) AS NUMERIC(18,4))   
		END) AS VLR_CONV_IT,  
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0
			WHEN V.VLR_TROCO_CHQ = 0  THEN   0  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(V.VLR_TROCO_CHQ AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_TROCO_CHQ_IT,  
		(CASE  WHEN V.VLR_LIQ_VD =0 THEN 0	
			WHEN V.VLR_LIQ_VD = ISNULL(V.VLR_NCC,0) THEN  
			CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18,2))  
		ELSE  
			CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20,10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20,10))) * CAST(ISNULL(V.VLR_NCC,0) AS NUMERIC(18,2))) AS NUMERIC(18,2))   
		END) AS VLR_NCC_IT,                                       
		V.VD_TROCA_FIDEL,  
		V.DT_ULT_ALT,  
		V.VLR_TOT_PROD,  
		I.DT_VD DT_VD_IT,  
		ISNULL(I.CD_GRP_COMIS,0) AS  CD_GRP_COMIS,  
		I.LISTA_PROD,  
		I.PERC_DESC_VERBA,  
		I.CST_PIS,  
		I.CST_COFINS,  
		I.VLR_BASE_PIS ,  
		I.VLR_BASE_COFINS,  
		I.PERC_ALIQ_PIS,  
		I.PERC_ALIQ_COFINS,  
		I.VLR_PIS,  
		I.VLR_COFINS,  
		ISNULL(I.VLR_CUSTO_GER,0) AS VLR_CUSTO_GER,
		ISNULL(TIPO_TRIBUTACAO_PIS_COFINS,0)TIPO_TRIBUTACAO_PIS_COFINS,
		ISNULL(TIPO_IMPOSTO,0) AS TIPO_IMPOSTO,
		V.QT_PARC_CONV,
		ISNULL(V.CD_CONV,0) AS CD_CONV,
		ISNULL(V.FLAG_NFCE,0) AS FLAG_NFCE,
		ISNULL(I.DEPENDENTE,0) AS DEPENDENTE,
		I.TP_PROD,
		I.PERC_DESC_DIFF,
		ISNULL(I.PERC_DESC_MIN,0) AS PERC_DESC_MIM,
		I.PERC_DESC_MAX,
		I.DS_PERC_COMIS,
		I.DS_VLR_COMIS,
		V.CGC_CPF,
		1 TP_VD,
		ROUND((((I.TOT_IT - I.VLR_DESC_TOT_RAT) * I.PERC_COMIS) / 100),2) AS VL_COMIS,
		COALESCE(I.PERC_FECOP, 0) AS PERC_FECOP,
		V.CD_USU_CANCEL,
		V.NM_COMPRADOR,
		V.TP_VD_API,
		V.NR_CARTAO_API,
		I.PERC_RED_BASE_CALC_EFET,
	    I.PERC_ICMS_EFET,
	    I.PERC_ICMS_RET,
		I.PERC_ST,
		I.VLR_BASE_CALC_EFET, 
		I.VLR_ICMS_EFET,
		I.VLR_BASE_CALC_RET,
		I.VLR_ICMS_RET,
        COALESCE(I.VLR_FECOP, 0) AS VLR_FECOP,
        V.NR_ECF_UUID AS UUID,
		COALESCE(I.ALIQ_EFET_ICMS, 0) AS ALIQ_EFET_ICMS_IT,
		COALESCE(I.PERC_EFET_RED_BASE_CALC, 0) AS PERC_EFET_RED_BASE_CALC_IT,
		COALESCE(I.VLR_BASE_CALC_EFET, 0) AS VLR_BASE_CALC_EFET_IT,
		COALESCE(I.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_IT,
		COALESCE(V.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_CAB,
		COALESCE(V.VLR_BASE_CALC_EFET, 0) AS VLR_BASE_CALC_EFET_CAB,
		COALESCE(I.LIBERA_VD_CONV, 1) AS LIBERA_VD_CONV
	FROM 
		PDV_VD AS V   
		INNER    JOIN DBO.PDV_VD_IT AS I ON   
			V.CD_EMP        = I.CD_EMP AND   
			V.CD_FILIAL = I.CD_FILIAL AND   
			V.CD_VD         = I.CD_VD         
		AND V.DT_VD = I.DT_VD   
		LEFT OUTER JOIN DBO.PDV_VD_IT_REC AS IR ON   
			I.CD_EMP        = IR.CD_EMP AND   
			I.CD_FILIAL = IR.CD_FILIAL AND   
			I.CD_VD         = IR.CD_VD AND   
			I.CD_IT         = IR.CD_IT  
		LEFT OUTER JOIN GLB_TP_DESCONTO ON
			I.TIPO_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO 		
		INNER JOIN PDV_VD_DEV_EST_PROD_IMP DEV ON 	DEV.CD_EMP = V.CD_EMP
			AND DEV.CD_FILIAL = V.CD_FILIAL
			AND DEV.CD_VD = V.CD_VD		
			AND DEV.CD_PROD = I.CD_PROD
	WHERE       
		V.CD_EMP = 1   
		AND V.ST_VD = 1  
		AND I.ST_IT = 1
		AND I.TP_PROD IN(10,11)
	UNION ALL	
	SELECT
		I.CD_EMP,
		I.CD_FILIAL,
		I.CD_NF CD_VD,
		S.CD_VEND,
		S.DT_EMI_NF DT_CONSD,
		0 CD_CX,
		I.DT_EMI_NF DT_VD,
		I.CD_PROD,
		I.QT_IT,
		S.NF_NF NR_ECF,
		I.VLR_TOT_IT - I.VLR_DESC_IT TOT_IT,
		I.VLR_DESC_IT,
		I.VLR_DESC_IT VLR_DESC_IT_LIQ,
		0 VLR_DESC_VERBA,
		(I.VLR_DESC_IT) DESC_TOTAL_IT,
		(I.QT_IT*I.VLR_IT) TOT_IT_BRUTO,
		0 VLR_DESC_TOT_RAT,
		I.VLR_IT,
		I.PERC_DESC_IT TX_DESC,
		T.CD_TRIB_FC,
		I.ALIQ_ICMS TX_ICMS_IT,
		I.ALIQ_ICMS TX_ICMS_IT_CHEIO,
		I.PERC_REDU_BASE_ICMS TX_RED_IT,
		S.VLR_DESC,
		0 TIPO,
		CASE WHEN I.VLR_TOT_IT > 0 THEN  
				CONVERT(FLOAT, (I.VLR_DESC_IT) / I.VLR_TOT_IT)    
		ELSE 0 END AS    PERC_DESC,
		0 VLR_DINH,
		0 VLR_CHQS,
		0 VLR_CARTAO,
		0 VLR_TICKETS,
		S.VLR_NF VLR_DUP,
		0 VLR_CONV,
		0 VLR_TROCO_CHQ,
		S.VLR_NF VLR_LIQ_VD,
		I.CD_IT,
		S.HR_EMI_NF HR_VD,
		S.CD_USU,
		S.CD_CLI,
		CASE WHEN I.QT_IT > 0 THEN   
				(((I.VLR_TOT_IT - I.VLR_DESC_IT) / I.QT_IT) * 
				CASE WHEN I.PERC_REDU_BASE_ICMS > 0 THEN
					((I.ALIQ_ICMS * I.PERC_REDU_BASE_ICMS) / 100.0000)
				ELSE
					I.ALIQ_ICMS
				END) / 100.0000   
		ELSE 
			0 
		END  VLR_IMPOSTOS,
		I.VLR_CUSTO VLR_CUSTO_UNI_LIQ,
		I.VLR_CUSTO VLR_CUSTO_BRUTO,
		0 TIPO_DESCONTO,
		'SEM DESCONTO'  DS_TIPO_DESCONTO,
		S.CD_PED NR_ORC,
		S.VERSAO_APLICATIVO  VS_PDV,
		0 ORIG_ORC,
		'' NR_CARTAO_MARKA,
		I.PIS_COFINS,
		I.VLR_IT VLR_PMC,
		I.QT_IT * I.VLR_IT VLR_PMC_TOTAL,
		00 VLR_OFERTA,
		00 VLR_DESC_CAD,
		00 DESC_FIXADO_CAD,
		00 PERC_DESC_FIDEL,
		00 PERC_DESC_FIDEL_MAX,
		00 VLR_DESC_OFERTA,
		00 VLR_DESC_REAL,
		ISNULL(R.CD_MEDICO_REC,0) AS CD_MEDICO_REC,
		I.PERC_COMI,
		I.VLR_CUSTO,
		I.VLR_CUSTO_MD VLR_CUSTO_MEDIO,
		PERC_COMI_CTR,
		0 VD_OPERADOR,
		S.CD_USU CD_USU_OPE,
		I.PERC_COMI PERC_COMIS,
		ISNULL(O.CD_ORC,0) AS NR_PED_TELEVD,
		00 VLR_COMISSAO_FABRIC,
		'NOTA FISCAL VENDA' ORIG_VENDA,
		00 VLR_DINH_IT,
		00 VLR_CHQS_IT,
		00 VLR_CHQS_IT_VISTA,
		00 VLR_CHQS_IT_PRAZO,
		00 VLR_CARTAO_IT,
		00 VLR_TICKETS_IT,
		(CASE WHEN I.VLR_TOT_IT = S.VLR_NF THEN  
					CAST((I.VLR_TOT_IT) AS NUMERIC(18,2))  
			  WHEN S.VLR_NF > 0 THEN
					CAST(((CAST((I.VLR_TOT_IT - I.VLR_DESC_IT + I.VLR_PROD_FRETE) AS NUMERIC(20,10))  / CAST(S.VLR_NF AS NUMERIC(20,10))) * CAST(S.VLR_NF AS NUMERIC(18,2))) AS NUMERIC(18,2))  
 		ELSE
			0	
		END) AS VLR_DUP_IT,	
		00 VLR_CONV_IT,
		00 VLR_TROCO_CHQ_IT,
		00 VLR_NCC_IT,
		00 VD_TROCA_FIDEL,
		S.DT_ULT_ALT,
		VLR_TOT_PROD,
		I.DT_EMI_NF DT_VD_IT,
		00 CD_GRP_COMIS,
		I.LISTA_PROD,
		00 PERC_DESC_VERBA,
		I.CST_PIS,
		I.CST_COFINS,
		I.VLR_BASE_PIS,
		I.VLR_BASE_COFINS,
		I.PERC_ALIQ_PIS,
		I.PERC_ALIQ_COFINS,
		I.VLR_PIS,
		I.VLR_COFINS,
		I.VLR_CUSTO_GERENCIAL_TRANSF VLR_CUSTO_GER,
		I.TIPO_TRIBUTACAO_PIS_COFINS,
		00 TIPO_IMPOSTO,
		0 QT_PARC_CONV,
		0 CD_CONV,
		0 FLAG_NFCE,
		0 AS DEPENDENTE,
		I.TP_PROD,
		0 AS PERC_DESC_DIFF,
		0 AS PERC_DESC_MIM,
		0 AS PERC_DESC_MAX,
		'' DS_PERC_COMIS,
		'' DS_VLR_COMIS,
		S.CNPJ_DESTINATARIO,
		2 TP_VD,
		ROUND((((I.VLR_TOT_IT - I.VLR_DESC_IT) * I.PERC_COMI) / 100),2) AS VL_COMIS,
		COALESCE(I.PERC_FECOP, 0) AS PERC_FECOP,
		0 AS CD_USU_CANCEL,
		'' AS NM_COMPRADOR,
		0 TP_VD_API,
		'' AS NR_CARTAO_API,
		0 PERC_RED_BASE_CALC_EFET,
	    0 PERC_ICMS_EFET,
	    0 PERC_ICMS_RET,
		0 PERC_ST,
		0 VLR_BASE_CALC_EFET, 
		0 VLR_ICMS_EFET,
		0 VLR_BASE_CALC_RET,
		0 VLR_ICMS_RET,
		COALESCE(I.VLR_FECOP, 0) AS VLR_FECOP,
		S.UUID AS UUID,
		COALESCE(I.ALIQ_EFET_ICMS, 0) AS ALIQ_EFET_ICMS_IT,
		COALESCE(I.PERC_EFET_RED_BASE_CALC, 0) AS PERC_EFET_RED_BASE_CALC_IT,
		COALESCE(I.VLR_EFET_BASE_ICMS, 0) AS VLR_BASE_CALC_EFET_IT,
		COALESCE(I.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_IT,
		COALESCE(S.VLR_EFET_ICMS, 0) AS VLR_EFET_ICMS_CAB,
		COALESCE(S.VLR_BASE_CALC_EFET, 0) AS VLR_BASE_CALC_EFET_CAB,
		1 AS LIBERA_VD_CONV
	FROM 
		EST_NF_SAI_VENDAS V
		INNER JOIN EST_NF_SAI S ON 
			V.CD_EMP	= S.CD_EMP AND
			V.CD_FILIAL = S.CD_FILIAL AND
			V.CD_NF		= S.CD_NF 
		INNER JOIN EST_NF_SAI_IT  I ON 
			S.CD_EMP	= I.CD_EMP AND
			S.CD_FILIAL = I.CD_FILIAL AND
			S.DT_EMI_NF = I.DT_EMI_NF AND
			S.CD_NF		= I.CD_NF
		INNER JOIN EST_TRIB T ON 
			I.CD_TRIB = T.CD_TRIB
        LEFT JOIN EST_NF_SAI_PED_VD E ON 
			E.CD_NF     = V.CD_NF AND
			E.CD_FILIAL = V.CD_FILIAL AND
			E.CD_EMP    = V.CD_EMP
        LEFT JOIN TELE_ORC_EST_PED_VD  O ON 
				E.CD_PED = O.CD_PED AND
				E.CD_FILIAL = O.CD_FILIAL AND
				E.CD_EMP = O.CD_EMP
		LEFT JOIN EST_NF_SAI_EST_NF_NFE_INU INU ON 
			V.CD_EMP	= INU.CD_EMP AND
			V.CD_FILIAL = INU.CD_FILIAL AND
			V.CD_NF		= INU.CD_NF
		LEFT JOIN EST_NF_SAI_CANCEL C ON 
			V.CD_EMP	= C.CD_EMP AND
			V.CD_FILIAL = C.CD_FILIAL AND
			V.CD_NF		= C.CD_NF
		LEFT OUTER JOIN EST_NF_SAI_IT_RECEITA R ON
			I.CD_EMP = R.CD_EMP AND
			I.CD_FILIAL = R.CD_FILIAL AND
			I.CD_NF = R.CD_NF AND
			I.CD_PROD = R.CD_PROD AND
			I.CD_IT = R.CD_IT 
	WHERE
		S.STS_NF=0
		AND INU.CD_EMP IS NULL
		AND C.CD_EMP IS NULL 
		AND V.CD_EMP =1
